// Copyright (c) Microsoft Corporation. All rights reserved.

function OnFinish(selProj, selObj)
{
	try
	{
		var strProjectPath = wizard.FindSymbol("PROJECT_PATH");
		var strProjectName = wizard.FindSymbol("PROJECT_NAME");
		if(wizard.FindSymbol("AUTOMATION"))
			wizard.AddSymbol("SAFE_IDL_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC2_FILE_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC_FILE_NAME",CreateSafeRCFileName(strProjectName) + ".rc");

		selProj = CreateProject(strProjectName, strProjectPath);

		AddCommonConfig(selProj, strProjectName);
		AddSpecificConfig(selProj, strProjectName);
		selProj.Object.keyword = "MFCDLLProj";

		SetupFilters(selProj);

		AddFilesToProjectWithInfFile(selProj, strProjectName);

		SetCommonPchSettings(selProj);

		var Sdl = wizard.FindSymbol("SDL_CHECK");

		if (Sdl) 
		{
			EnableSDLCheckSettings(selProj);
		}

		selProj.Object.Save();
	}
	catch(e)
	{
		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function SetFileProperties(projfile, strName)
{
	if (strName == "dllmain.cpp") {
		var Configs = projfile.Object.FileConfigurations;
		for(var i=1;i<=Configs.Count;++i) {
			var Config = Configs(i);
			var CLTool = Config.Tool;
			CLTool.CompileAsManaged = 0; // Force no /CLR
			CLTool.UsePrecompiledHeader  = 0; // No pre-compiled headers			
		}
	}
}

function GetTargetName(strName, strProjectName, strResPath, strHelpPath)
{
	try
	{
		var strTarget = strName;
		if (strName.substr(0, 4) == "root")
		{
			if (strName == "root.ico")
			{
				strTarget = strResPath + "\\" + strProjectName + strName.substr(4);
			}
			else if (strName == "root.rc2")
			{
				var strRC2FileName = wizard.FindSymbol("RC2_FILE_NAME");
				strTarget = strResPath + "\\" + strRC2FileName + strName.substr(4);
			}
			else if (strName == "root.idl")
			{
				var strProjectName = wizard.FindSymbol("SAFE_IDL_NAME");
				strTarget = strProjectName + ".idl";
			}
			else
				strTarget = strProjectName + strName.substr(4);
			return strTarget;
		}

		switch (strName)
		{
			case "readme.txt":
				strTarget = "ReadMe.txt";
				break;
			case "all.rc":
			case "dlgall.rc":
				strTarget = wizard.FindSymbol("RC_FILE_NAME");
				break;
			case "dlgres.h":
			case "resource.h":
				strTarget = "Resource.h";
				break;
			default:
				break;
		}
		return strTarget; 
	}
	catch(e)
	{
		throw e;
	}
}

function AddSpecificConfig(proj, strProjectName)
{
	try
	{
		var bAutomation = wizard.FindSymbol("AUTOMATION");
		var bRegular = wizard.FindSymbol("DLL_TYPE_REGULAR");
		var bRegularStatic = wizard.FindSymbol("DLL_TYPE_REGULAR_STATIC");

		var oConfigs = proj.Object.Configurations;
	for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
	{
		var config = oConfigs(nCntr);
		var bDebug = false;
		if (-1 != config.Name.indexOf("Debug"))
			bDebug = true;

		config.ConfigurationType = typeDynamicLibrary;
		config.CharacterSet = charSetUNICODE;

		var CLTool = config.Tools("VCCLCompilerTool");
		var strDefines = CLTool.PreprocessorDefinitions;
		if (strDefines != "") strDefines += ";";
		strDefines += GetPlatformDefine(config);
		strDefines += (bDebug ? "_WINDOWS;_DEBUG" : "_WINDOWS;NDEBUG");
		if (bRegular || bRegularStatic)
			strDefines += ";_USRDLL";
		else
			strDefines += ";_AFXEXT";

		if (bRegularStatic)
		{
			config.UseOfMFC = useMfcStatic;
		}
		else
		{
			config.UseOfMFC = useMfcDynamic;
		}

		CLTool.PreprocessorDefinitions = strDefines;

		var MidlTool = config.Tools("VCMidlTool");
		MidlTool.MkTypLibCompatible = false;
		MidlTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");
		if (bAutomation)
		{
			var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
			MidlTool.TypeLibraryName = "$(IntDir)" + strIdlName +".tlb";
			if (IsPlatformWin32(config))
				MidlTool.TargetEnvironment = midlTargetWin32;
		}

		var RCTool = config.Tools("VCResourceCompilerTool");
		RCTool.Culture = wizard.FindSymbol("LCID");
		RCTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");
		RCTool.AdditionalIncludeDirectories = "$(IntDir)";
		
		var LinkTool = config.Tools("VCLinkerTool");
		LinkTool.LinkIncremental = (bDebug ? linkIncrementalYes : linkIncrementalNo);
		var strDefFile = ".\\" + strProjectName + ".def";		
		LinkTool.ModuleDefinitionFile = strDefFile;

		if (bAutomation)
		{
			LinkTool.RegisterOutput = true;
		}
	} //for
	} //try
	catch(e)
	{
		throw e;
	}
}


// SIG // Begin signature block
// SIG // MIIkQwYJKoZIhvcNAQcCoIIkNDCCJDACAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // maQY239eyIBS6fk4wEPJBbE5R79g5R54BTkWrADO6qCg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFggwghYEAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggfcwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIDC2FIOW85+PZATdJY2z5SLRnYsmlKRtXw+fehIH
// SIG // GM6hMIGKBgorBgEEAYI3AgEMMXwweqBggF4AZABlAGYA
// SIG // YQB1AGwAdABfAGIAZAA1ADgAYwA4AGEANQAtADAAYQA0
// SIG // ADEALQA0ADAAYwA2AC0AYgBjADgAMgAtADcAMwA5ADQA
// SIG // OABmAGQAOQA5ADEANAAwAC4AagBzoRaAFGh0dHA6Ly9t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBABji
// SIG // VgcATmTbYIGodxOmMcHfimVT5ffl9WOaarr7eubflnoC
// SIG // 4NFi7lakdVv6k5qylVPDTJLmej5gkWeZwvQucVQc3b4x
// SIG // KV59VOZ+lVVkmnHWBU76B7dvqfuXSBvWtKHkBS6wkydW
// SIG // OzToN2SAOnV5SRkNKRy7FFnAZ7PAE/llLlITBEW0G7KA
// SIG // YBLC2iFYywn/Lmsz2Tpi59IbR4NqjM837tYH1v0yA6cc
// SIG // LCdvJ2b8qdCP56x/Ael6vra8V7ZaAY3fMWmhlyPPEaRS
// SIG // ovEu+tTfehecpRZSiDfU6friB52TH6NWqTnOOErPrywm
// SIG // 57FeGlQFRbkdtqlNQ49RcPFXkdFhzY6hghNJMIITRQYK
// SIG // KwYBBAGCNwMDATGCEzUwghMxBgkqhkiG9w0BBwKgghMi
// SIG // MIITHgIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBOgYLKoZI
// SIG // hvcNAQkQAQSgggEpBIIBJTCCASECAQEGCisGAQQBhFkK
// SIG // AwEwMTANBglghkgBZQMEAgEFAAQgLNoc3gTNgsiLOYKj
// SIG // F96M83eoitozLN/JECBAXazCIRsCBliLoquw1RgTMjAx
// SIG // NzAyMDkwMzQ2NDcuMzk1WjAEgAIB9KCBuaSBtjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjE0OEMtQzRC
// SIG // OS0yMDY2MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNloIIOzzCCBnEwggRZoAMCAQICCmEJ
// SIG // gSoAAAAAAAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDEwMB4X
// SIG // DTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIxNDY1NVowfDEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpHQ28dxGKOiDs
// SIG // /BOX9fp/aZRrdFQQ1aUKAIKF++18aEssX8XD5WHCdrc+
// SIG // Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCIhFRD
// SIG // DNdNuDgIs0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAyWGBG
// SIG // 8lhHhjKEHnRhZ5FfgVSxz5NMksHEpl3RYRNuKMYa+YaA
// SIG // u99h/EbBJx0kZxJyGiGKr0tkiVBisV39dx898Fd1rL2K
// SIG // Qk1AUdEPnAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6Kgox
// SIG // 8NpOBpG2iAg16HgcsOmZzTznL0S6p/TcZL2kAcEgCZN4
// SIG // zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQBgkr
// SIG // BgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIoxkPND
// SIG // e3xGG8UzaFqFbVUwGQYJKwYBBAGCNxQCBAweCgBTAHUA
// SIG // YgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMB
// SIG // Af8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186a
// SIG // GMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // Um9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJB
// SIG // dXRfMjAxMC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSBlTCB
// SIG // kjCBjwYJKwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIBFjFo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vUEtJL2RvY3Mv
// SIG // Q1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQeMiAd
// SIG // AEwAZQBnAGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0AGEA
// SIG // dABlAG0AZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4IC
// SIG // AQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F4qn+
// SIG // +ldtGTCzwsVmyWrf9efweL3HqJ4l4/m87WtUVwgrUYJE
// SIG // Evu5U4zM9GASinbMQEBBm9xcF/9c+V4XNZgkVkt070IQ
// SIG // yK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmptWvk
// SIG // x872ynoAb0swRCQiPM/tA6WWj1kpvLb9BOFwnzJKJ/1V
// SIG // ry/+tuWOM7tiX5rbV0Dp8c6ZZpCM/2pif93FSguRJuI5
// SIG // 7BlKcWOdeyFtw5yjojz6f32WapB4pm3S4Zz5Hfw42JT0
// SIG // xqUKloakvZ4argRCg7i1gJsiOCC1JeVk7Pf0v35jWSUP
// SIG // ei45V3aicaoGig+JFrphpxHLmtgOR5qAxdDNp9DvfYPw
// SIG // 4TtxCd9ddJgiCGHasFAeb73x4QDf5zEHpJM692VHeOj4
// SIG // qEir995yfmFrb3epgcunCaw5u+zGy9iCtHLNHfS4hQEe
// SIG // gPsbiSpUObJb2sgNVZl6h3M7COaYLeqN4DMuEin1wC9U
// SIG // JyH3yKxO2ii4sanblrKnQqLJzxlBTeCG+SqaoxFmMNO7
// SIG // dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp3lfB
// SIG // 0d4wwP3M5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa7wkn
// SIG // HNWzfjUeCLraNtvTX4/edIhJEjCCBNowggPCoAMCAQIC
// SIG // EzMAAAC0Qzoc/ra6UokAAAAAALQwDQYJKoZIhvcNAQEL
// SIG // BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcN
// SIG // MTYwOTA3MTc1NjU4WhcNMTgwOTA3MTc1NjU4WjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjE0OEMtQzRC
// SIG // OS0yMDY2MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEA4IFPu7XRMDo/gwC3zFaf95usurNd
// SIG // ZBEegtZ61+4g+7PRCAFjl1enwuJMVqi1V9ugxt+z0Rix
// SIG // Hn6RrBkZUW1z/p4tbSRCIMTI70Zp0G8cTGFqlDMPlD7b
// SIG // om8lKr8Z0s4DOlIVgEVlG/3Ptf83smhmmWWt7v++gU1D
// SIG // ngt4CdYqjz2KtAcz2bBQJFHvf/Uk1BUMj3YY2Fa8tW2j
// SIG // KXTYdQdIQBmOZhiRAgJwG0Hb+SehGXXGlqj6QS+7esU0
// SIG // pjCgl5PHGmwAWoK2jABnksvMTdJsqePEXnkLAZWuqKS5
// SIG // Iv75RV4/fRkbYZw3dNmjUcXuSNlUMxSDX7LnD3uwH8mX
// SIG // vpmFcQIDAQABo4IBGzCCARcwHQYDVR0OBBYEFAyTq0XU
// SIG // bAt3L/MrV/PpJMSHB/RfMB8GA1UdIwQYMBaAFNVjOlyK
// SIG // MZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeG
// SIG // RWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3Js
// SIG // L3Byb2R1Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAx
// SIG // LmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKG
// SIG // Pmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2Vy
// SIG // dHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwG
// SIG // A1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
// SIG // DQYJKoZIhvcNAQELBQADggEBAAK1YVugp9JqrCYvtsI0
// SIG // o3T7qHuQsYItqIkSXaT2ggtZPSfneh15LPjLcs9Ha+9v
// SIG // 3uuSbe6v+16hkYR4419Re8SXMeBQje26mfeIKr9RauIj
// SIG // 5DdH3WbixYUI7P51cet6bUmJJSEdnY4W5Fik5qiVtZu0
// SIG // k6GKLLicITq8AVEfmOCf8+3qUMy7N4QpavAibKVPrhMR
// SIG // eWZkcCejDPq03ky7UH7En3/pgVEE3q4UX+YODBCBukas
// SIG // O2IS57XRCjDw0yns+tNwMW4KeiRRwiLmDiK3Q1GqU1Ui
// SIG // 9SS159N1eCmhOltpCuCtfJnPn7SSKAd+qnDEMoZbSg7Y
// SIG // RLb1PmcfecPyK1OhggN4MIICYAIBATCB46GBuaSBtjCB
// SIG // szELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjE0OEMt
// SIG // QzRCOS0yMDY2MSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoFAAMV
// SIG // AAfAlZeuLk5uydN19tmJUZiLIG06oIHCMIG/pIG8MIG5
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBFU046NERFOS0w
// SIG // QzVFLTNFMDkxKzApBgNVBAMTIk1pY3Jvc29mdCBUaW1l
// SIG // IFNvdXJjZSBNYXN0ZXIgQ2xvY2swDQYJKoZIhvcNAQEF
// SIG // BQACBQDcRcxqMCIYDzIwMTcwMjA4MTY1NzE0WhgPMjAx
// SIG // NzAyMDkxNjU3MTRaMHYwPAYKKwYBBAGEWQoEATEuMCww
// SIG // CgIFANxFzGoCAQAwCQIBAAIBYAIB/zAHAgEAAgIZJjAK
// SIG // AgUA3Ecd6gIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgor
// SIG // BgEEAYRZCgMBoAowCAIBAAIDB6EgoQowCAIBAAIDB6Eg
// SIG // MA0GCSqGSIb3DQEBBQUAA4IBAQCECjQu7kF5Iqb88j0D
// SIG // 0vqIn4MP+5T7SboaHLwqnBv0jW1fRVI7TCgjYkaux540
// SIG // GZZaZYzgTo1jzlQBb/BK2S1UiaNEjPFIin6gt6K4Kbzy
// SIG // +GX/UFu8a3m+7baM0jslpnYXerMLx7NKj2wNCnCrE2QJ
// SIG // xR3AM734Gw6G3e75+3Xwmr536+rCBPZRqmxfMGn9REVG
// SIG // kT0HBtbfI7Ks4FdyvW20A1zw0fHVnyndDlIc1Rap3OMM
// SIG // SCPAPRtQ2a4nbX1EZmyRQtBRIJvcZxGUc+UxPRnKI9P4
// SIG // kQK9xqNBNvbWhOmipV4VFg85e+YckgGCwaaA4AaqdpYS
// SIG // pfY6y7gZbkWuQcDmMYIC9TCCAvECAQEwgZMwfDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0
// SIG // IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAAC0Qzoc/ra6
// SIG // UokAAAAAALQwDQYJYIZIAWUDBAIBBQCgggEyMBoGCSqG
// SIG // SIb3DQEJAzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0B
// SIG // CQQxIgQgVj/ztRbEDUESf22qZzK7kN4GQph3IzYubPMI
// SIG // PDD2qKQwgeIGCyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGx
// SIG // BBQHwJWXri5ObsnTdfbZiVGYiyBtOjCBmDCBgKR+MHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAtEM6
// SIG // HP62ulKJAAAAAAC0MBYEFCIZDUl9KiWAc59GjNf9uo0e
// SIG // Ge80MA0GCSqGSIb3DQEBCwUABIIBAG7MfxtydpaEaGTc
// SIG // sJqx3mGzPUHyGCiYlEPX7GnnHayZAt6Ux8/BTmqRa5WK
// SIG // Ltmbq4w5VnVsbdOlWNonK3wcF/VCu8i0pu7vFIvPuOwL
// SIG // I/g1bfC7DZ4O9DE2S+lCgYfopdcQd0YwNcRoK3Q8UiWc
// SIG // G6tbX6AF1e2V+t15BrffoElEPChItjuC4JirAiNl1+eO
// SIG // EoziHFACm5svA2YzA2tcSomCBOMNzzgqorXqKEzeqgjh
// SIG // FcOBjBmOB/BzHr1jLvLdM7d1S2WexXceO6Qzv3/weiYN
// SIG // lJjyx5MzicYmKJ4pi192RNxLlWbiUkHmKGiAPzqLiiKV
// SIG // 0Um0CV8/khdXdw7NgoQ=
// SIG // End signature block
